/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.IInjectBlock;
import com.aptana.core.util.ImmutableTuple;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionsUtil {
    public static final <T, U extends T> List<T> addToList(List<T> list, U ... items) {
        if (list != null && items != null) {
            int i = 0;
            while (i < items.length) {
                list.add(items[i]);
                ++i;
            }
            if (list instanceof ArrayList) {
                ((ArrayList)list).trimToSize();
            }
        }
        return list;
    }

    public static final <T, U extends T> List<T> addToList(List<T> list, List<U> items) {
        if (list != null && items != null) {
            list.addAll(items);
        }
        return list;
    }

    public static final <T> T[] toArray(List<T> list, int startIndex, int endIndex) {
        if (CollectionsUtil.isEmpty(list)) {
            return list.toArray();
        }
        List<Object> subList = list.subList(startIndex, endIndex);
        return subList.toArray((Object[])Array.newInstance(list.get(0).getClass(), subList.size()));
    }

    public static final <T> T[] toArray(List<T> list) {
        return CollectionsUtil.toArray(list, 0, list.size());
    }

    public static final <T, U extends T> Set<T> addToSet(Set<T> set, U ... items) {
        if (set != null && items != null) {
            int i = 0;
            while (i < items.length) {
                set.add(items[i]);
                ++i;
            }
        }
        return set;
    }

    public static <T> void filter(Collection<T> source, Collection<T> destination, IFilter<? super T> filter) {
        if (source != null && destination != null) {
            if (filter != null) {
                for (T item : source) {
                    if (!filter.include(item)) continue;
                    destination.add(item);
                }
            } else {
                destination.addAll(source);
            }
            if (destination instanceof ArrayList) {
                ((ArrayList)destination).trimToSize();
            }
        }
    }

    public static <T> T find(Collection<T> collection, IFilter<T> filter) {
        if (collection != null && filter != null) {
            for (T item : collection) {
                if (!filter.include(item)) continue;
                return item;
            }
        }
        return null;
    }

    public static <T> List<T> filter(Collection<T> collection, IFilter<T> filter) {
        ArrayList result = new ArrayList(collection == null ? 0 : collection.size());
        CollectionsUtil.filter(collection, result, filter);
        return result;
    }

    public static <T> void filterInPlace(Collection<T> collection, IFilter<? super T> filter) {
        if (collection != null && filter != null) {
            Iterator<T> iterator = collection.iterator();
            while (iterator.hasNext()) {
                T item = iterator.next();
                if (filter.include(item)) continue;
                iterator.remove();
            }
        }
    }

    public static <T> List<T> getListValue(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static <T, U> Map<T, U> getMapValue(Map<T, U> list) {
        if (list == null) {
            return Collections.emptyMap();
        }
        return list;
    }

    public static <T> Set<T> getSetValue(Set<T> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public static <T> T getFirstElement(List<T> list) {
        if (!CollectionsUtil.isEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public static <T> Collection<T> getNonOverlapping(Collection<T> collection1, Collection<T> collection2) {
        Collection<T> result = CollectionsUtil.union(collection1, collection2);
        if (!CollectionsUtil.isEmpty(result)) {
            result.removeAll(CollectionsUtil.intersect(collection1, collection2));
            if (result instanceof ArrayList) {
                ((ArrayList)result).trimToSize();
            }
        }
        return result;
    }

    public static <T> Collection<T> intersect(Collection<T> collection1, Collection<T> collection2) {
        if (CollectionsUtil.isEmpty(collection1) || CollectionsUtil.isEmpty(collection2)) {
            return Collections.emptyList();
        }
        HashSet<T> intersection = new HashSet<T>(collection1);
        intersection.retainAll(collection2);
        return intersection;
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T, U> boolean isEmpty(Map<T, U> map) {
        return map == null || map.isEmpty();
    }

    public static <T, U> void map(Collection<T> source, Collection<U> destination, IMap<? super T, U> mapper) {
        if (source != null && destination != null && mapper != null) {
            for (T item : source) {
                U value = mapper.map(item);
                if (value == null) continue;
                destination.add(value);
            }
            if (destination instanceof ArrayList) {
                ((ArrayList)destination).trimToSize();
            }
        }
    }

    public static <T, U> List<U> map(Collection<T> collection, IMap<? super T, U> mapper) {
        if (CollectionsUtil.isEmpty(collection)) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(collection.size());
        CollectionsUtil.map(collection, result, mapper);
        return result;
    }

    public static <T, U> List<U> map(Iterator<T> iterator, IMap<? super T, U> mapper) {
        if (iterator == null || mapper == null) {
            return Collections.emptyList();
        }
        ArrayList<U> result = new ArrayList<U>();
        while (iterator.hasNext()) {
            result.add(mapper.map(iterator.next()));
        }
        return result;
    }

    public static final <T> Set<T> newInOrderSet(T ... items) {
        return CollectionsUtil.addToSet(new LinkedHashSet(items != null ? items.length : 0), items);
    }

    public static final <T> List<T> newList(T ... items) {
        return CollectionsUtil.addToList(new ArrayList(items != null ? items.length : 0), items);
    }

    public static final <T> Set<T> newSet(T ... items) {
        return CollectionsUtil.addToSet(new HashSet(items != null ? items.length : 0), items);
    }

    public static final <T> Map<T, T> newMap(T ... items) {
        return CollectionsUtil.addToMap(new HashMap(items != null ? items.length / 2 : 0), items);
    }

    public static final <T> Map<T, T> newInOrderMap(T ... items) {
        return CollectionsUtil.addToMap(new LinkedHashMap(items != null ? items.length / 2 : 0), items);
    }

    public static final <T, U> void addToMap(Class<T> keyType, Class<U> valueType, Map<T, U> map, Object ... items) {
        if (keyType != null && valueType != null && map != null && !ArrayUtil.isEmpty(items)) {
            if (items.length % 2 != 0) {
                throw new IllegalArgumentException("Length of list of items must be multiple of 2");
            }
            int i = 0;
            while (i < items.length) {
                Object value;
                Object keyObject = items[i];
                if (!keyType.isAssignableFrom(keyObject.getClass())) {
                    String message = MessageFormat.format("Key {0} was not of the expected type: {1}", i, keyType);
                    throw new IllegalArgumentException(message);
                }
                T key = keyType.cast(keyObject);
                Object valueObject = items[i + 1];
                if (valueObject == null) {
                    value = null;
                    map.put(key, value);
                } else if (valueType.isAssignableFrom(valueObject.getClass())) {
                    value = valueType.cast(valueObject);
                    map.put(key, value);
                } else {
                    String message = MessageFormat.format("Value {0} was not of the expected type: {1}", i + 1, valueType);
                    throw new IllegalArgumentException(message);
                }
                i += 2;
            }
        }
    }

    public static final <T, U> Map<T, U> newTypedMap(Class<T> keyType, Class<U> valueType, Object ... items) {
        Map result;
        if (keyType != null && valueType != null && !ArrayUtil.isEmpty(items)) {
            result = new HashMap();
            CollectionsUtil.addToMap(keyType, valueType, result, items);
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    public static final <T, U extends T> Map<T, T> addToMap(Map<T, T> map, U ... items) {
        if (map != null && items != null) {
            if (items.length % 2 != 0) {
                throw new IllegalArgumentException("Length of list of items must be multiple of 2");
            }
            int i = 0;
            while (i < items.length) {
                map.put(items[i], items[i + 1]);
                i += 2;
            }
        }
        return map;
    }

    public static <T> void removeDuplicates(List<T> list) {
        LinkedHashSet<T> set = new LinkedHashSet<T>(list);
        list.clear();
        list.addAll(set);
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
    }

    public static <T> Collection<T> union(Collection<? extends T> collection1, Collection<? extends T> collection2) {
        if (CollectionsUtil.isEmpty(collection1)) {
            if (CollectionsUtil.isEmpty(collection2)) {
                return Collections.emptyList();
            }
            return new ArrayList<T>(collection2);
        }
        if (CollectionsUtil.isEmpty(collection2)) {
            return new ArrayList<T>(collection1);
        }
        HashSet<T> union = new HashSet<T>(collection1.size() + collection2.size());
        union.addAll(collection1);
        union.addAll(collection2);
        return new ArrayList(union);
    }

    private CollectionsUtil() {
    }

    public static <K, V> Map<K, V> mapFromValues(Collection<V> values, IMap<V, K> valueTokeyMapper) {
        if (CollectionsUtil.isEmpty(values)) {
            return Collections.emptyMap();
        }
        HashMap<K, V> map = new HashMap<K, V>(values.size());
        for (V value : values) {
            K key = valueTokeyMapper.map(value);
            if (key == null) {
                throw new IllegalStateException(MessageFormat.format("Generated key for value {0} was null, which is not allowed.", value.toString()));
            }
            map.put(key, value);
        }
        return map;
    }

    public static <K, V> K inject(Collection<V> collection, K collector, IInjectBlock<V, K> block) {
        if (CollectionsUtil.isEmpty(collection)) {
            return collector;
        }
        for (V item : collection) {
            collector = block.execute(collector, item);
        }
        return collector;
    }

    public static <T> ImmutableTuple<List<T>, List<T>> partition(Collection<T> collection, IFilter<T> filter) {
        if (CollectionsUtil.isEmpty(collection)) {
            return new ImmutableTuple<List<T>, List<T>>(new ArrayList(0), new ArrayList(0));
        }
        if (filter == null) {
            return new ImmutableTuple<List<T>, List<T>>(new ArrayList<T>(collection), new ArrayList(0));
        }
        int size = collection.size();
        ArrayList<T> trueResults = new ArrayList<T>(size / 2);
        ArrayList<T> falseResults = new ArrayList<T>(size / 2);
        for (T item : collection) {
            if (filter.include(item)) {
                trueResults.add(item);
                continue;
            }
            falseResults.add(item);
        }
        trueResults.trimToSize();
        falseResults.trimToSize();
        return new ImmutableTuple<List<T>, List<T>>(trueResults, falseResults);
    }

    public static int size(Collection<? extends Object> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }
}

